SELECT vrevisions.for_vrevisions('
CREATE OR REPLACE FUNCTION objects_a16_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 16) THEN
        NEW.part := get_part(NEW.the_geom);
        IF (NEW.part = OLD.part) THEN
            RETURN NEW;
        END IF;
    END IF;
    DELETE FROM objects_a WHERE id = OLD.id AND zmin >= 16;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l12_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 15) THEN
        NEW.part := get_part(NEW.the_geom);
        IF (NEW.part = OLD.part) THEN
            RETURN NEW;
        END IF;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 12 AND zmin < 15;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l15_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 15) THEN
        NEW.part := get_part(NEW.the_geom);
        IF (NEW.part = OLD.part) THEN
            RETURN NEW;
        END IF;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 15;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_p16_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 16) THEN
        NEW.part := get_part(NEW.the_geom);
        IF (NEW.part = OLD.part) THEN
            RETURN NEW;
        END IF;
    END IF;
    DELETE FROM objects_p WHERE id = OLD.id AND zmin >= 16;
    INSERT INTO objects_p VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;
');
