CREATE TABLE validation.preset (
    id bigserial PRIMARY KEY,
    name text NOT NULL,
    is_public boolean NOT NULL DEFAULT false,
    created_at timestamp with time zone NOT NULL DEFAULT now(),
    created_by bigint NOT NULL CHECK (created_by > 0),
    checks text[] NOT NULL
);

CREATE UNIQUE INDEX validation_preset_created_by_name_index
    ON validation.preset
    USING btree (created_by, name);

INSERT INTO validation.preset (name, is_public, created_by, checks) VALUES
    ('prepare stable branch GLOBAL', TRUE, 82282794,
        '{ad_fc_validity,ad_geometry,ad_hierarchy,ad_hierarchy_geom,ad_naming,ad_relations,ad_topology,addr_geometry,addr_naming,addr_relations,addr_uniqueness,base_only,bld_el_intersections,bld_geometry,bld_height,bld_urban_relations,flooding,hydro_fc_validity,hydro_geometry,hydro_naming,hydro_relations,hydro_topology_face,hydro_topology_linear,poi_geometry,poi_naming,poi_relations,poi_uniqueness,rd_ad_inclusion,rd_ad_relations,rd_ad_uniqueness,rd_rd_el_relations,relief_fc_validity,relief_geometry,relief_naming,relief_relations,relief_topology,road_gaps,road_naming,transport_airport_geometry,transport_airport_naming,transport_airport_relations,transport_duplicates_check,transport_metro_exit,transport_metro_geometry,transport_metro_naming,transport_metro_relations,transport_metro_thread_time,transport_metro_topology,transport_naming,transport_railway_geometry,transport_railway_naming,transport_railway_relations,transport_railway_topology,transport_route_relations,transport_thread_relations,transport_thread_station_distance,transport_thread_time,transport_thread_topology_validity,transport_tram_topology,transport_waterway_naming,transport_waterway_relations,transport_waterway_topology,urban_fc_validity,urban_geometry,urban_naming,urban_relations,urban_roadnet_fc_validity,urban_roadnet_geometry,urban_roadnet_naming,urban_roadnet_parking,urban_roadnet_relations,urban_roadnet_topology,urban_topology,vegetation_fc_validity,vegetation_geometry,vegetation_naming,vegetation_relations,vegetation_topology}');

INSERT INTO validation.preset (name, is_public, created_by, checks) VALUES
    ('prepare stable branch RKUB', TRUE, 82282794,
        '{cond_cam_logic,cond_lane_duplicates,cond_lane_logic,cond_lane_topo,conditions_duplicates,conditions_logic,conditions_relations,conditions_schedules,conditions_topo,dead_ends,length,linked_attributes_err,linked_attributes_warn,local_names_ad_nm,local_names_hydro_nm,local_names_poi_nm,local_names_rd_nm,local_names_relief_nm,local_names_transport_airport_nm,local_names_transport_metro_nm,local_names_transport_nm,local_names_transport_railway_nm,local_names_transport_waterway_nm,local_names_urban_nm,local_names_urban_roadnet_nm,local_names_vegetation_nm,pedestrian_roadnet_strong_connectivity,rd_topology,strong_connectivity,strong_connectivity_by_fc,traffic_lights,uc_open_at,zlevels}');

INSERT INTO validation.preset (name, is_public, created_by, checks) VALUES
    ('prepare stable branch UKR', TRUE, 82282794,
        '{ukr_names_ad_nm,ukr_names_hydro_nm,ukr_names_poi_nm,ukr_names_rd_nm,ukr_names_relief_nm,ukr_names_transport_airport_nm,ukr_names_transport_metro_nm,ukr_names_transport_nm,ukr_names_transport_railway_nm,ukr_names_transport_waterway_nm,ukr_names_urban_nm,ukr_names_urban_roadnet_nm,ukr_names_vegetation_nm}');

INSERT INTO validation.preset (name, is_public, created_by, checks) VALUES
    ('prepare stable branch FRANCE', TRUE, 82282794,
        '{cond_cam_logic,cond_lane_duplicates,cond_lane_logic,cond_lane_topo,conditions_duplicates,conditions_logic,conditions_relations,conditions_schedules,conditions_topo,dead_ends,length,linked_attributes_err,linked_attributes_warn,pedestrian_roadnet_strong_connectivity,rd_topology,strong_connectivity,strong_connectivity_by_fc,traffic_lights,uc_open_at,zlevels}');
