CREATE TYPE service.validation_export_result_type_new AS ENUM (
    'validated_and_exported',
    'fatal_errors_found'
);

ALTER TABLE service.validation_export_task
  ALTER COLUMN result TYPE service.validation_export_result_type_new
    USING (CASE WHEN result = 'critical_errors_found'
            THEN 'fatal_errors_found'::service.validation_export_result_type_new
            ELSE 'validated_and_exported'::service.validation_export_result_type_new END);

DROP TYPE service.validation_export_result_type;

ALTER TYPE service.validation_export_result_type_new RENAME TO validation_export_result_type;
