SELECT vrevisions.for_vrevisions('
CREATE TABLE objects_a16_part4
(
  CONSTRAINT objects_a16_part4_pkey PRIMARY KEY (id),
  CONSTRAINT objects_a16_part4_part_check CHECK (part = 4),
  CONSTRAINT objects_a16_part4_zmin_check CHECK (zmin >= 16),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
)
INHERITS (objects_a);

CREATE INDEX objects_a16_part4_the_geom_center_domain_service_attrs_idx
  ON objects_a16_part4
  USING gist
  (the_geom, the_center, domain_attrs, service_attrs);

CREATE TRIGGER update_objects_a16_part4_trigger
  BEFORE UPDATE
  ON objects_a16_part4
  FOR EACH ROW
  EXECUTE PROCEDURE objects_a16_update_trigger();


CREATE OR REPLACE FUNCTION objects_a_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO objects_a16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_a16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_a16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_a16_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO objects_a16_part4 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_a_insert_trigger() function!'';
        END CASE;
    ELSIF (NEW.zmin >= 14) THEN
        INSERT INTO objects_a14 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 12) THEN
        INSERT INTO objects_a12 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 10) THEN
        INSERT INTO objects_a10 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 8) THEN
        INSERT INTO objects_a8 VALUES (NEW.*);
    ELSE
        INSERT INTO objects_a7 VALUES (NEW.*); 
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


CREATE TABLE objects_l12_part4
(
  CONSTRAINT objects_l12_part4_pkey PRIMARY KEY (id),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0),
  CONSTRAINT objects_l12_part4_part_check CHECK (part = 4),
  CONSTRAINT objects_l12_part4_zmin_check CHECK (zmin >= 12 AND zmin < 15)
)
INHERITS (objects_l);


CREATE INDEX objects_l12_part4_the_geom_domain_service_attrs_idx
  ON objects_l12_part4
  USING gist
  (the_geom, domain_attrs, service_attrs);


CREATE TRIGGER update_objects_l12_part4_trigger
  BEFORE UPDATE
  ON objects_l12_part4
  FOR EACH ROW
  EXECUTE PROCEDURE objects_l12_update_trigger();


CREATE TABLE objects_l15_part4
(
  CONSTRAINT objects_l15_part4_pkey PRIMARY KEY (id),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0),
  CONSTRAINT objects_l15_part4_part_check CHECK (part = 4),
  CONSTRAINT objects_l15_part4_zmin_check CHECK (zmin >= 15)
)
INHERITS (objects_l);


CREATE INDEX objects_l15_part4_the_geom_domain_service_attrs_idx
  ON objects_l15_part4
  USING gist
  (the_geom, domain_attrs, service_attrs);


CREATE TRIGGER update_objects_l15_part4_trigger
  BEFORE UPDATE
  ON objects_l15_part4
  FOR EACH ROW
  EXECUTE PROCEDURE objects_l15_update_trigger();


CREATE OR REPLACE FUNCTION objects_l_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := get_part(NEW.the_geom);
    IF (NEW.zmin >= 15) THEN
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO objects_l15_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_l15_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_l15_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_l15_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO objects_l15_part4 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_l_insert_trigger() function!'';
        END CASE;
    ELSIF (NEW.zmin >= 12) THEN
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO objects_l12_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_l12_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_l12_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_l12_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO objects_l12_part4 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_l_insert_trigger() function!'';
        END CASE;
    ELSIF (NEW.zmin >= 10) THEN
        INSERT INTO objects_l10 VALUES (NEW.*);
    ELSE
        INSERT INTO objects_l9 VALUES (NEW.*); 
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


CREATE TABLE objects_p16_part4
(
  CONSTRAINT objects_p16_part4_pkey PRIMARY KEY (id),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0),
  CONSTRAINT objects_p16_part4_part_check CHECK (part = 4),
  CONSTRAINT objects_p16_part4_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);


CREATE INDEX objects_p16_part4_the_geom_domain_service_attrs_idx
  ON objects_p16_part4
  USING gist
  (the_geom, domain_attrs, service_attrs);


CREATE TRIGGER update_objects_p16_part4_trigger
  BEFORE UPDATE
  ON objects_p16_part4
  FOR EACH ROW
  EXECUTE PROCEDURE objects_p16_update_trigger();

CREATE OR REPLACE FUNCTION objects_p_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO objects_p16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_p16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_p16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_p16_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO objects_p16_part4 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_p_insert_trigger() function!'';
        END CASE;
    ELSIF (NEW.zmin >= 14) THEN
        INSERT INTO objects_p14 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 12) THEN
        INSERT INTO objects_p12 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 10) THEN
        INSERT INTO objects_p10 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 8) THEN
        INSERT INTO objects_p8 VALUES (NEW.*);
    ELSE
        INSERT INTO objects_p7 VALUES (NEW.*);
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


CREATE OR REPLACE FUNCTION bbox_parts()
  RETURNS geometry[] AS
$BODY$
BEGIN
  RETURN ARRAY[
    ST_SetSRID(ST_MakeBox2D(ST_Point(2000001,4500001), ST_Point(7000000,147687969)),3395),
    ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,4500001), ST_Point(20037483,147687969)),3395),
    ST_SetSRID(ST_MakeBox2D(ST_Point(-3000000,4500001), ST_Point(900000,147687969)),3395),
    ST_SetSRID(ST_MakeBox2D(ST_Point(900001,4500001), ST_Point(2000000,147687969)),3395)
  ];
END;
$BODY$
  LANGUAGE plpgsql IMMUTABLE
  COST 1;
');
