-- Create new schema and new objects

CREATE SCHEMA vrevisions_stable;

SET search_path=vrevisions_stable,public;

CREATE TABLE branch_mask
(
    branch_mask_id bigserial PRIMARY KEY,
    branches hstore NOT NULL
);

CREATE INDEX branch_mask_branches_btree_idx
    ON branch_mask
    USING btree
    (branches);

CREATE INDEX branch_mask_branches_gist_idx
    ON branch_mask
    USING gist
    (branches);

INSERT INTO branch_mask(branches) VALUES ('1=>1'::hstore); -- approved branch 1 by default

-- Move table vrevisions_stable_1.objects_r to schema vrevisions_stable

DROP VIEW IF EXISTS vrevisions_stable_1.complex_objects_indirect_highlight_view;
DROP VIEW IF EXISTS vrevisions_stable_1.complex_objects_l_highlight_view;

ALTER TABLE IF EXISTS vrevisions_stable_1.objects_r SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_r DROP CONSTRAINT objects_r_pkey;

-- Create table in case there is no vrevisions_stable_1 schema

CREATE TABLE IF NOT EXISTS objects_r (LIKE vrevisions_trunk.objects_r INCLUDING CONSTRAINTS);

ALTER TABLE IF EXISTS objects_r ADD COLUMN branch_mask_id bigint NOT NULL REFERENCES branch_mask(branch_mask_id) DEFAULT 1;
ALTER TABLE IF EXISTS objects_r ALTER COLUMN branch_mask_id DROP DEFAULT;

ALTER TABLE IF EXISTS objects_r ADD CONSTRAINT objects_r_pkey PRIMARY KEY (id, branch_mask_id);

DROP INDEX IF EXISTS objects_r_master_id_slave_id_idx;
DROP INDEX IF EXISTS objects_r_slave_id_idx;
    
CREATE INDEX objects_r_branch_mask_id_master_id_slave_id_idx
    ON objects_r
    USING btree
    (branch_mask_id, master_id, slave_id);

CREATE INDEX objects_r_branch_mask_id_slave_id_idx
    ON objects_r
    USING btree
    (branch_mask_id, slave_id);

SET search_path=public;

-- Create new views across all stable schemas

CREATE OR REPLACE FUNCTION vrevisions_stable.prepare_schema(
    schemaname text,
    branch_id bigint)
    RETURNS void AS
$$
BEGIN
    EXECUTE format('
        SET search_path=%I,public;

        DROP VIEW IF EXISTS complex_objects_indirect_highlight_view;
        DROP VIEW IF EXISTS complex_objects_l_highlight_view;
        DROP TABLE IF EXISTS objects_r;

        CREATE VIEW objects_r AS
            SELECT id, commit_id, domain_attrs, master_id, slave_id
                FROM vrevisions_stable.objects_r
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%s'';

        CREATE OR REPLACE VIEW complex_objects_indirect_highlight_view AS
            SELECT r.master_id,
                s.id,
                s.the_geom,
                s.zmin,
                s.zmax,
                r.domain_attrs,
                r.slave_id,
                s.part
            FROM objects_r r, objects_r r_next, objects_l s
            WHERE r.slave_id = r_next.master_id AND r_next.slave_id = s.id;

        CREATE OR REPLACE VIEW complex_objects_l_highlight_view AS
            SELECT r.master_id,
                r.slave_id AS id,
                s.the_geom,
                s.zmin,
                s.zmax,
                s.part
            FROM objects_r r, objects_l s
            WHERE r.slave_id = s.id;',
        schemaname, branch_id::text);
END;
$$ LANGUAGE plpgsql;

SELECT vrevisions_stable.prepare_schema('vrevisions_stable_1', 1)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable_1'
    LIMIT 1;
