ALTER TABLE social.feedback_task ADD COLUMN hash_value CHARACTER(32) NOT NULL DEFAULT 'old';
ALTER TABLE social.star_trek_issue ADD COLUMN sync_hash_value CHARACTER(32) NOT NULL DEFAULT 'old';

CREATE OR REPLACE FUNCTION social.feedback_task_insert_update_trigger() RETURNS TRIGGER AS
$BODY$
BEGIN
    NEW.hash_value = MD5(ROW(NEW.hidden,NEW.closed_at,NEW.deployed_at)::text);
    RETURN NEW;
END;
$BODY$
LANGUAGE PLPGSQL;

DROP TRIGGER IF EXISTS feedback_task_insert_trigger ON social.feedback_task;
CREATE TRIGGER feedback_task_insert_trigger
BEFORE INSERT
ON social.feedback_task
FOR EACH ROW
EXECUTE PROCEDURE social.feedback_task_insert_update_trigger();

DROP TRIGGER IF EXISTS feedback_task_update_trigger ON social.feedback_task;
CREATE TRIGGER feedback_task_update_trigger
BEFORE UPDATE
ON social.feedback_task
FOR EACH ROW
EXECUTE PROCEDURE social.feedback_task_insert_update_trigger();

