CREATE OR REPLACE FUNCTION vrevisions.for_vrevisions(
    sql text,
    skip_schemaname text DEFAULT ''::text)
  RETURNS SETOF text AS
$BODY$
DECLARE
    r RECORD;
BEGIN
    FOR r IN
      SELECT DISTINCT schemaname FROM pg_tables
       WHERE schemaname like 'vrevisions_%'
         AND schemaname != 'vrevisions_stable'
         AND schemaname != skip_schemaname
       ORDER BY 1
      LOOP
        EXECUTE 'SET search_path='||r.schemaname||',public;'||sql;
        RETURN NEXT r.schemaname;
    END LOOP;
END;
$BODY$
LANGUAGE plpgsql VOLATILE;

SELECT vrevisions.for_vrevisions('
DROP VIEW IF EXISTS complex_objects_l_highlight_view;
CREATE VIEW complex_objects_l_highlight_view AS
 SELECT r.master_id,
    l.id,
    l.the_geom,
    l.zmin,
    l.zmax,
    l.part
   FROM objects_r r JOIN objects_l l ON r.slave_id = l.id;
');
