SELECT vrevisions.for_vrevisions('
ALTER TABLE objects_l12_part0
    DROP CONSTRAINT objects_l12_part0_zmin_check,
    ADD CONSTRAINT objects_l12_part0_zmin_check CHECK (zmin >= 12);
ALTER TABLE objects_l12_part3
    DROP CONSTRAINT objects_l12_part3_zmin_check,
    ADD CONSTRAINT objects_l12_part3_zmin_check CHECK (zmin >= 12);
ALTER TABLE objects_l12_part4
    DROP CONSTRAINT objects_l12_part4_zmin_check,
    ADD CONSTRAINT objects_l12_part4_zmin_check CHECK (zmin >= 12);
ALTER TABLE objects_l12_part5
    DROP CONSTRAINT objects_l12_part5_zmin_check,
    ADD CONSTRAINT objects_l12_part5_zmin_check CHECK (zmin >= 12);
ALTER TABLE objects_l12_part6
    DROP CONSTRAINT objects_l12_part6_zmin_check,
    ADD CONSTRAINT objects_l12_part6_zmin_check CHECK (zmin >= 12);


CREATE OR REPLACE FUNCTION objects_l_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := get_part(NEW.the_geom);
    IF (NEW.zmin < 10) THEN
        INSERT INTO objects_l9 VALUES (NEW.*);
    ELSIF (NEW.zmin < 12) THEN
        INSERT INTO objects_l10 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 15 AND NEW.part = 1) THEN
        INSERT INTO objects_l15_part1 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 15 AND NEW.part = 2) THEN
        INSERT INTO objects_l15_part2 VALUES (NEW.*);
    ELSE
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO objects_l12_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_l12_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_l12_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_l12_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO objects_l12_part4 VALUES (NEW.*);
        WHEN 5 THEN
            INSERT INTO objects_l12_part5 VALUES (NEW.*);
        WHEN 6 THEN
            INSERT INTO objects_l12_part6 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_l_insert_trigger() function!'';
        END CASE;
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


CREATE OR REPLACE FUNCTION objects_l12_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 12) THEN
        NEW.part := get_part(NEW.the_geom);
        IF (NEW.part = OLD.part) THEN
            RETURN NEW;
        END IF;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 12;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


CREATE OR REPLACE FUNCTION objects_l12_14_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 15) THEN
        NEW.part := get_part(NEW.the_geom);
        IF (NEW.part = OLD.part) THEN
            RETURN NEW;
        END IF;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 12 AND zmin < 15;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


DROP TRIGGER update_objects_l12_part1_trigger ON objects_l12_part1;
CREATE TRIGGER update_objects_l12_part1_trigger
  BEFORE UPDATE
  ON objects_l12_part1
  FOR EACH ROW
  EXECUTE PROCEDURE objects_l12_14_update_trigger();

DROP TRIGGER update_objects_l12_part2_trigger ON objects_l12_part2;
CREATE TRIGGER update_objects_l12_part2_trigger
  BEFORE UPDATE
  ON objects_l12_part2
  FOR EACH ROW
  EXECUTE PROCEDURE objects_l12_14_update_trigger();


INSERT INTO objects_l12_part0 SELECT * FROM objects_l15_part0;
INSERT INTO objects_l12_part3 SELECT * FROM objects_l15_part3;
INSERT INTO objects_l12_part4 SELECT * FROM objects_l15_part4;
INSERT INTO objects_l12_part5 SELECT * FROM objects_l15_part5;
INSERT INTO objects_l12_part6 SELECT * FROM objects_l15_part6;

DROP TABLE IF EXISTS objects_l15_part0;
DROP TABLE IF EXISTS objects_l15_part3;
DROP TABLE IF EXISTS objects_l15_part4;
DROP TABLE IF EXISTS objects_l15_part5;
DROP TABLE IF EXISTS objects_l15_part6;
');
