ALTER TABLE social.feedback_task ADD COLUMN bucket text NOT NULL DEFAULT 'outgoing';
ALTER TABLE social.feedback_task ADD CONSTRAINT bucket_constraint
    CHECK (bucket = ANY (ARRAY[
        'outgoing'::text,
        'incoming'::text,
        'deferred'::text
    ]));

ALTER TABLE social.feedback_task ALTER COLUMN bucket SET DEFAULT 'incoming';

CREATE INDEX feedback_task_bucket_idx ON social.feedback_task USING btree (bucket);
