SET search_path=vrevisions_stable,public;


CREATE OR REPLACE FUNCTION vrevisions_stable.bbox_parts()
    RETURNS geometry[] AS
$$
BEGIN
    RETURN ARRAY[
        ST_SetSRID(ST_MakeBox2D(ST_Point(2000001,4500001), ST_Point(7000000,147687969)),3395),
        ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,4500001), ST_Point(20037483,147687969)),3395),
        ST_SetSRID(ST_MakeBox2D(ST_Point(-3000000,4500001), ST_Point(900000,147687969)),3395),
        ST_SetSRID(ST_MakeBox2D(ST_Point(900001,4500001), ST_Point(2000000,147687969)),3395),
        ST_SetSRID(ST_MakeBox2D(ST_Point(-20037483,-147687969), ST_Point(-3000001,147687969)),3395),
        ST_SetSRID(ST_MakeBox2D(ST_Point(-3000000,-147687969), ST_Point(20037483,147687969)),3395)
    ];
END;
$$
    LANGUAGE plpgsql IMMUTABLE
    COST 1;


CREATE OR REPLACE FUNCTION vrevisions_stable.get_part(the_geom geometry)
    RETURNS integer AS
$$
DECLARE
    geom geometry := ST_SetSRID(the_geom, 3395);
    part integer := 1;
    bbox geometry;
BEGIN
    FOREACH bbox IN ARRAY vrevisions_stable.bbox_parts() LOOP
        IF (geom @ bbox) THEN
            RETURN part;
        END IF;
        part := part + 1;
    END LOOP;
    RETURN 0;
END;
$$
    LANGUAGE plpgsql IMMUTABLE
    COST 1;


SET search_path=public;