SET search_path=vrevisions_stable_1,public;

DROP VIEW IF EXISTS complex_objects_indirect_highlight_view;
DROP VIEW IF EXISTS complex_objects_l_highlight_view;

ALTER TABLE IF EXISTS objects SET SCHEMA vrevisions_stable;

ALTER TABLE IF EXISTS objects_p SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p7 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p8 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p10 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p12 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p14 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p16_part0 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p16_part1 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p16_part2 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p16_part3 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p16_part4 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p16_part5 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_p16_part6 SET SCHEMA vrevisions_stable;

ALTER TABLE IF EXISTS objects_a SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a7 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a8 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a10 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a12 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a14 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a16_part0 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a16_part1 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a16_part2 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a16_part3 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a16_part4 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a16_part5 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_a16_part6 SET SCHEMA vrevisions_stable;

ALTER TABLE IF EXISTS objects_l SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l9 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l10 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l12_part0 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l12_part1 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l12_part2 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l12_part3 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l12_part4 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l12_part5 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l12_part6 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l15_part1 SET SCHEMA vrevisions_stable;
ALTER TABLE IF EXISTS objects_l15_part2 SET SCHEMA vrevisions_stable;

ALTER TABLE IF EXISTS objects_c SET SCHEMA vrevisions_stable;

SET search_path=vrevisions_stable,public;

-- Brake object_c inheritance

ALTER TABLE IF EXISTS objects_c RENAME TO objects_c_temp;
CREATE TABLE IF NOT EXISTS objects_c_temp (LIKE vrevisions_trunk.objects_c);
ALTER TABLE objects_c_temp DROP CONSTRAINT IF EXISTS objects_c_pkey;

CREATE TABLE objects_c
(
    id bigint NOT NULL,
    commit_id bigint NOT NULL,
    domain_attrs hstore,
    service_attrs hstore,
    branch_mask_id bigint NOT NULL REFERENCES branch_mask(branch_mask_id),
    CONSTRAINT objects_c_pkey PRIMARY KEY (id, branch_mask_id),
    CONSTRAINT objects_c_commit_id_check CHECK (commit_id > 0)
);

WITH bm AS (
  SELECT branch_mask_id
    FROM branch_mask
    WHERE branches='1=>1'::hstore
    ORDER BY branch_mask_id
    LIMIT 1
)
INSERT INTO objects_c (id, commit_id, domain_attrs, service_attrs, branch_mask_id)
    SELECT id, commit_id, domain_attrs, service_attrs, bm.branch_mask_id
        FROM objects_c_temp, bm;

DROP TABLE IF EXISTS objects_c_temp;

-- Create objects table

CREATE TABLE IF NOT EXISTS objects
(
    id bigint NOT NULL,
    commit_id bigint NOT NULL,
    the_geom geometry,
    zmin integer NOT NULL DEFAULT 0,
    zmax integer,
    domain_attrs hstore,
    service_attrs hstore,
    CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
);

-- Create objects_a

CREATE TABLE IF NOT EXISTS objects_a
(
    area double precision NOT NULL,
    the_center geometry,
    part integer
)
INHERITS (objects);

CREATE TABLE IF NOT EXISTS objects_a7
(
    CONSTRAINT objects_a7_zmin_check CHECK (zmin <= 7)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a8
(
    CONSTRAINT objects_a8_zmin_check CHECK (zmin >= 8 AND zmin < 10)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a10
(
    CONSTRAINT objects_a10_zmin_check CHECK (zmin >= 10 AND zmin < 12)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a12
(
    CONSTRAINT objects_a12_zmin_check CHECK (zmin >= 12 AND zmin < 14)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a14
(
    CONSTRAINT objects_a14_zmin_check CHECK (zmin >= 14 AND zmin < 16)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a16_part0
(
    CONSTRAINT objects_a16_part0_part_check CHECK (part = 0),
    CONSTRAINT objects_a16_part0_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a16_part1
(
    CONSTRAINT objects_a16_part1_part_check CHECK (part = 1),
    CONSTRAINT objects_a16_part1_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a16_part2
(
    CONSTRAINT objects_a16_part2_part_check CHECK (part = 2),
    CONSTRAINT objects_a16_part2_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a16_part3
(
    CONSTRAINT objects_a16_part3_part_check CHECK (part = 3),
    CONSTRAINT objects_a16_part3_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a16_part4
(
    CONSTRAINT objects_a16_part4_part_check CHECK (part = 4),
    CONSTRAINT objects_a16_part4_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a16_part5
(
    CONSTRAINT objects_a16_part5_part_check CHECK (part = 5),
    CONSTRAINT objects_a16_part5_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_a);

CREATE TABLE IF NOT EXISTS objects_a16_part6
(
    CONSTRAINT objects_a16_part6_part_check CHECK (part = 6),
    CONSTRAINT objects_a16_part6_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_a);

-- Create objects_l

CREATE TABLE IF NOT EXISTS objects_l
(
    length double precision NOT NULL DEFAULT 0,
    part integer
)
INHERITS (objects);

CREATE TABLE IF NOT EXISTS objects_l9
(
    CONSTRAINT objects_l9_zmin_check CHECK (zmin <= 9)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l10
(
    CONSTRAINT objects_l10_zmin_check CHECK (zmin >= 10 AND zmin < 12)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l12_part0
(
    CONSTRAINT objects_l12_part0_part_check CHECK (part = 0),
    CONSTRAINT objects_l12_part0_zmin_check CHECK (zmin >= 12)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l12_part1
(
    CONSTRAINT objects_l12_part1_part_check CHECK (part = 1),
    CONSTRAINT objects_l12_part1_zmin_check CHECK (zmin >= 12 AND zmin < 15)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l12_part2
(
    CONSTRAINT objects_l12_part2_part_check CHECK (part = 2),
    CONSTRAINT objects_l12_part2_zmin_check CHECK (zmin >= 12 AND zmin < 15)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l12_part3
(
    CONSTRAINT objects_l12_part3_part_check CHECK (part = 3),
    CONSTRAINT objects_l12_part3_zmin_check CHECK (zmin >= 12)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l12_part4
(
    CONSTRAINT objects_l12_part4_part_check CHECK (part = 4),
    CONSTRAINT objects_l12_part4_zmin_check CHECK (zmin >= 12)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l12_part5
(
    CONSTRAINT objects_l12_part5_part_check CHECK (part = 5),
    CONSTRAINT objects_l12_part5_zmin_check CHECK (zmin >= 12)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l12_part6
(
    CONSTRAINT objects_l12_part6_part_check CHECK (part = 6),
    CONSTRAINT objects_l12_part6_zmin_check CHECK (zmin >= 12)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l15_part1
(
    CONSTRAINT objects_l15_part1_part_check CHECK (part = 1),
    CONSTRAINT objects_l15_part1_zmin_check CHECK (zmin >= 15)
)
INHERITS (objects_l);

CREATE TABLE IF NOT EXISTS objects_l15_part2
(
    CONSTRAINT objects_l15_part2_part_check CHECK (part = 2),
    CONSTRAINT objects_l15_part2_zmin_check CHECK (zmin >= 15)
)
INHERITS (objects_l);

-- Create objects_a

CREATE TABLE IF NOT EXISTS objects_p
(
    part integer
)
INHERITS (objects);

CREATE TABLE IF NOT EXISTS objects_p7
(
    CONSTRAINT objects_p7_zmin_check CHECK (zmin <= 7)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p8
(
    CONSTRAINT objects_p8_zmin_check CHECK (zmin >= 8 AND zmin < 10)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p10
(
    CONSTRAINT objects_p10_zmin_check CHECK (zmin >= 10 AND zmin < 12)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p12
(
    CONSTRAINT objects_p12_zmin_check CHECK (zmin >= 12 AND zmin < 14)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p14
(
    CONSTRAINT objects_p14_zmin_check CHECK (zmin >= 14 AND zmin < 16)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p16_part0
(
    CONSTRAINT objects_p16_part0_part_check CHECK (part = 0),
    CONSTRAINT objects_p16_part0_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p16_part1
(
    CONSTRAINT objects_p16_part1_part_check CHECK (part = 1),
    CONSTRAINT objects_p16_part1_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p16_part2
(
    CONSTRAINT objects_p16_part2_part_check CHECK (part = 2),
    CONSTRAINT objects_p16_part2_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p16_part3
(
    CONSTRAINT objects_p16_part3_part_check CHECK (part = 3),
    CONSTRAINT objects_p16_part3_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p16_part4
(
    CONSTRAINT objects_p16_part4_part_check CHECK (part = 4),
    CONSTRAINT objects_p16_part4_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p16_part5
(
    CONSTRAINT objects_p16_part5_part_check CHECK (part = 5),
    CONSTRAINT objects_p16_part5_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);

CREATE TABLE IF NOT EXISTS objects_p16_part6
(
    CONSTRAINT objects_p16_part6_part_check CHECK (part = 6),
    CONSTRAINT objects_p16_part6_zmin_check CHECK (zmin >= 16)
)
INHERITS (objects_p);

-- Prepare objects

ALTER TABLE objects_a DROP COLUMN IF EXISTS mesh;

ALTER TABLE objects ADD COLUMN branch_mask_id bigint REFERENCES branch_mask(branch_mask_id);
ALTER TABLE objects DROP CONSTRAINT IF EXISTS objects_pkey;
ALTER TABLE objects ADD CONSTRAINT objects_pkey PRIMARY KEY (id, branch_mask_id);

CREATE OR REPLACE FUNCTION prepare_table(
    tablename text)
    RETURNS void AS
$$
DECLARE
    mask_id bigint;
BEGIN
    mask_id := get_branch_mask_id('1=>1'::hstore);
    EXECUTE format('
        SET search_path=vrevisions_stable,public;

        DROP TRIGGER IF EXISTS update_%1$s_trigger ON %1$s;

        UPDATE %1$s SET branch_mask_id=%2$s;

        ALTER TABLE IF EXISTS %1$s DROP CONSTRAINT IF EXISTS %1$s_pkey;
        ALTER TABLE IF EXISTS %1$s ADD CONSTRAINT %1$s_pkey PRIMARY KEY (id, branch_mask_id);
        ALTER TABLE IF EXISTS %1$s ADD CONSTRAINT %1$s_branch_mask_id_fkey
            FOREIGN KEY (branch_mask_id)
            REFERENCES branch_mask(branch_mask_id);',
        tablename, mask_id::text);
END;
$$ LANGUAGE plpgsql;

-- Prepare objects_a

ALTER TABLE objects_a DROP CONSTRAINT IF EXISTS objects_a_pkey;
ALTER TABLE objects_a ADD CONSTRAINT objects_a_pkey PRIMARY KEY (id, branch_mask_id);
ALTER TABLE objects_a ADD CONSTRAINT objects_a_branch_mask_id_fkey
            FOREIGN KEY (branch_mask_id)
            REFERENCES branch_mask(branch_mask_id);

CREATE OR REPLACE FUNCTION objects_a_insert_trigger()
    RETURNS trigger AS
$$
BEGIN
    NEW.part := vrevisions_stable.get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO vrevisions_stable.objects_a16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO vrevisions_stable.objects_a16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO vrevisions_stable.objects_a16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO vrevisions_stable.objects_a16_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO vrevisions_stable.objects_a16_part4 VALUES (NEW.*);
        WHEN 5 THEN
            INSERT INTO vrevisions_stable.objects_a16_part5 VALUES (NEW.*);
        WHEN 6 THEN
            INSERT INTO vrevisions_stable.objects_a16_part6 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION 'Invalid part. Fix the objects_a_insert_trigger() function!';
        END CASE;
    ELSIF (NEW.zmin >= 14) THEN
        INSERT INTO vrevisions_stable.objects_a14 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 12) THEN
        INSERT INTO vrevisions_stable.objects_a12 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 10) THEN
        INSERT INTO vrevisions_stable.objects_a10 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 8) THEN
        INSERT INTO vrevisions_stable.objects_a8 VALUES (NEW.*);
    ELSE
        INSERT INTO vrevisions_stable.objects_a7 VALUES (NEW.*);
    END IF;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql VOLATILE
    COST 100;

DROP TRIGGER IF EXISTS insert_objects_trigger ON objects_a;

CREATE TRIGGER insert_objects_trigger
    BEFORE INSERT
    ON objects_a
    FOR EACH ROW
    EXECUTE PROCEDURE objects_a_insert_trigger();

SELECT prepare_table(tablename)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable'
        AND tablename LIKE 'objects\_a_%';

-- Prepare objects_l

ALTER TABLE objects_l DROP CONSTRAINT IF EXISTS objects_l_pkey;
ALTER TABLE objects_l ADD CONSTRAINT objects_l_pkey PRIMARY KEY (id, branch_mask_id);
ALTER TABLE objects_l ADD CONSTRAINT objects_l_branch_mask_id_fkey
            FOREIGN KEY (branch_mask_id)
            REFERENCES branch_mask(branch_mask_id);

CREATE OR REPLACE FUNCTION objects_l_insert_trigger()
    RETURNS trigger AS
$$
BEGIN
    NEW.part := vrevisions_stable.get_part(NEW.the_geom);
    IF (NEW.zmin < 10) THEN
        INSERT INTO vrevisions_stable.objects_l9 VALUES (NEW.*);
    ELSIF (NEW.zmin < 12) THEN
        INSERT INTO vrevisions_stable.objects_l10 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 15 AND NEW.part = 1) THEN
        INSERT INTO vrevisions_stable.objects_l15_part1 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 15 AND NEW.part = 2) THEN
        INSERT INTO vrevisions_stable.objects_l15_part2 VALUES (NEW.*);
    ELSE
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO vrevisions_stable.objects_l12_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO vrevisions_stable.objects_l12_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO vrevisions_stable.objects_l12_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO vrevisions_stable.objects_l12_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO vrevisions_stable.objects_l12_part4 VALUES (NEW.*);
        WHEN 5 THEN
            INSERT INTO vrevisions_stable.objects_l12_part5 VALUES (NEW.*);
        WHEN 6 THEN
            INSERT INTO vrevisions_stable.objects_l12_part6 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION 'Invalid part. Fix the objects_l_insert_trigger() function!';
        END CASE;
    END IF;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql VOLATILE
    COST 100;

DROP TRIGGER IF EXISTS insert_objects_l_trigger ON objects_l;

CREATE TRIGGER insert_objects_l_trigger
    BEFORE INSERT
    ON objects_l
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l_insert_trigger();

SELECT prepare_table(tablename)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable'
        AND tablename LIKE 'objects\_l_%';

-- Prepare objects_p

ALTER TABLE objects_p DROP CONSTRAINT IF EXISTS objects_p_pkey;
ALTER TABLE objects_p ADD CONSTRAINT objects_p_pkey PRIMARY KEY (id, branch_mask_id);
ALTER TABLE objects_p ADD CONSTRAINT objects_p_branch_mask_id_fkey
            FOREIGN KEY (branch_mask_id)
            REFERENCES branch_mask(branch_mask_id);

CREATE OR REPLACE FUNCTION objects_p_insert_trigger()
    RETURNS trigger AS
$$
BEGIN
    NEW.part := vrevisions_stable.get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE NEW.part
        WHEN 0 THEN
            INSERT INTO vrevisions_stable.objects_p16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO vrevisions_stable.objects_p16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO vrevisions_stable.objects_p16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO vrevisions_stable.objects_p16_part3 VALUES (NEW.*);
        WHEN 4 THEN
            INSERT INTO vrevisions_stable.objects_p16_part4 VALUES (NEW.*);
        WHEN 5 THEN
            INSERT INTO vrevisions_stable.objects_p16_part5 VALUES (NEW.*);
        WHEN 6 THEN
            INSERT INTO vrevisions_stable.objects_p16_part6 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION 'Invalid part. Fix the objects_p_insert_trigger() function!';
        END CASE;
    ELSIF (NEW.zmin >= 14) THEN
        INSERT INTO vrevisions_stable.objects_p14 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 12) THEN
        INSERT INTO vrevisions_stable.objects_p12 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 10) THEN
        INSERT INTO vrevisions_stable.objects_p10 VALUES (NEW.*);
    ELSIF (NEW.zmin >= 8) THEN
        INSERT INTO vrevisions_stable.objects_p8 VALUES (NEW.*);
    ELSE
        INSERT INTO vrevisions_stable.objects_p7 VALUES (NEW.*);
    END IF;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql VOLATILE
    COST 100;

DROP TRIGGER IF EXISTS insert_objects_p_trigger ON objects_p;

CREATE TRIGGER insert_objects_p_trigger
    BEFORE INSERT
    ON objects_p
    FOR EACH ROW
    EXECUTE PROCEDURE objects_p_insert_trigger();

SELECT prepare_table(tablename)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable'
        AND tablename LIKE 'objects\_p_%';

-- Finish objects

DROP FUNCTION prepare_table(text);

ALTER TABLE IF EXISTS objects ALTER COLUMN branch_mask_id SET NOT NULL;

ALTER TABLE IF EXISTS objects RENAME TO objects_g;

CREATE OR REPLACE FUNCTION vrevisions_stable.prepare_schema(
    schemaname text,
    branch_id bigint)
    RETURNS void AS
$$
BEGIN
    EXECUTE format('
        SET search_path=%I,public;

        DROP VIEW IF EXISTS complex_objects_indirect_highlight_view;
        DROP VIEW IF EXISTS complex_objects_l_highlight_view;

        DROP TABLE IF EXISTS objects_r;
        DROP TABLE IF EXISTS objects CASCADE;

        CREATE VIEW objects AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_g
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s''
            UNION ALL
            SELECT id, commit_id, NULL, 0, 0, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_c
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_c AS
            SELECT id, commit_id, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_c
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_p AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, part
                FROM vrevisions_stable.objects_p
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_l AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, length, part
                FROM vrevisions_stable.objects_l
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_a AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, area, the_center, part
                FROM vrevisions_stable.objects_a
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_r AS
            SELECT id, commit_id, domain_attrs, master_id, slave_id
                FROM vrevisions_stable.objects_r
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE OR REPLACE VIEW complex_objects_indirect_highlight_view AS
            SELECT r.master_id,
                l.id,
                l.the_geom,
                l.zmin,
                l.zmax,
                r.domain_attrs,
                r.slave_id,
                l.part
            FROM objects_r r, objects_r r_next, objects_l l
            WHERE r.slave_id = r_next.master_id AND r_next.slave_id = l.id;

        CREATE VIEW complex_objects_l_highlight_view AS
        SELECT r.master_id,
            l.id,
            l.the_geom,
            l.zmin,
            l.zmax,
            l.part
            FROM objects_r r JOIN objects_l l ON r.slave_id = l.id;

        DROP FUNCTION IF EXISTS objects_a_insert_trigger();
        DROP FUNCTION IF EXISTS objects_a7_update_trigger();
        DROP FUNCTION IF EXISTS objects_a8_update_trigger();
        DROP FUNCTION IF EXISTS objects_a10_update_trigger();
        DROP FUNCTION IF EXISTS objects_a12_update_trigger();
        DROP FUNCTION IF EXISTS objects_a12_update_trigger();
        DROP FUNCTION IF EXISTS objects_a14_update_trigger();
        DROP FUNCTION IF EXISTS objects_a16_update_trigger();

        DROP FUNCTION IF EXISTS objects_l_insert_trigger();
        DROP FUNCTION IF EXISTS objects_l9_update_trigger();
        DROP FUNCTION IF EXISTS objects_l10_update_trigger();
        DROP FUNCTION IF EXISTS objects_l12_update_trigger();
        DROP FUNCTION IF EXISTS objects_l12_14_update_trigger();
        DROP FUNCTION IF EXISTS objects_l15_update_trigger();

        DROP FUNCTION IF EXISTS objects_p_insert_trigger();
        DROP FUNCTION IF EXISTS objects_p_update_trigger();
        DROP FUNCTION IF EXISTS objects_p16_update_trigger();',
        schemaname, branch_id::text);
END;
$$ LANGUAGE plpgsql;


DROP VIEW IF EXISTS vrevisions_stable_1.objects_r;

SELECT vrevisions_stable.prepare_schema('vrevisions_stable_1', 1)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable_1'
    LIMIT 1;
