SET search_path=vrevisions_stable,public;

CREATE OR REPLACE FUNCTION create_branch_mask_index(
    tablename text)
    RETURNS void AS
$$
BEGIN
    EXECUTE format('
        SET search_path=vrevisions_stable,public;

        CREATE INDEX %1$s_branch_mask_id_idx
            ON %1$s
            USING btree
            (branch_mask_id);',
        tablename);
END;
$$ LANGUAGE plpgsql;

SELECT create_branch_mask_index(tablename)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable'
        AND tablename LIKE 'objects\_a_%';

SELECT create_branch_mask_index(tablename)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable'
        AND tablename LIKE 'objects\_l_%';

SELECT create_branch_mask_index(tablename)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable'
        AND tablename LIKE 'objects\_p_%';

SELECT create_branch_mask_index(tablename)
    FROM pg_tables
    WHERE schemaname='vrevisions_stable'
        AND tablename LIKE 'objects\_c_%';

DROP FUNCTION create_branch_mask_index(text);

SET search_path=public;
