SELECT vrevisions.for_vrevisions('
    CREATE OR REPLACE VIEW objects_g AS
        SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs
            FROM objects WHERE the_geom IS NOT NULL;
');


CREATE OR REPLACE FUNCTION vrevisions_stable.prepare_schema(
    schemaname text,
    branch_id bigint)
    RETURNS void AS
$$
BEGIN
    EXECUTE format('
        SET search_path=%I,public;

        DROP VIEW IF EXISTS complex_objects_indirect_highlight_view;
        DROP VIEW IF EXISTS complex_objects_l_highlight_view;

        DROP TABLE IF EXISTS objects_r;
        DROP TABLE IF EXISTS objects CASCADE;

        CREATE OR REPLACE VIEW objects_g AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_g
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_g
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s''
            UNION ALL
            SELECT id, commit_id, NULL, 0, 0, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_c
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_c AS
            SELECT id, commit_id, NULL::geometry AS the_geom, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_c
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_p AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, part
                FROM vrevisions_stable.objects_p
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_l AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, length, part
                FROM vrevisions_stable.objects_l
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_a AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, area, the_center, part
                FROM vrevisions_stable.objects_a
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_r AS
            SELECT id, commit_id, domain_attrs, master_id, slave_id
                FROM vrevisions_stable.objects_r
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE OR REPLACE VIEW complex_objects_indirect_highlight_view AS
            SELECT r.master_id,
                l.id,
                l.the_geom,
                l.zmin,
                l.zmax,
                r.domain_attrs,
                r.slave_id,
                l.part
            FROM objects_r r, objects_r r_next, objects_l l
            WHERE r.slave_id = r_next.master_id AND r_next.slave_id = l.id;

        CREATE VIEW complex_objects_l_highlight_view AS
        SELECT r.master_id,
            l.id,
            l.the_geom,
            l.zmin,
            l.zmax,
            l.part
            FROM objects_r r JOIN objects_l l ON r.slave_id = l.id;

        DROP FUNCTION IF EXISTS objects_a_insert_trigger();
        DROP FUNCTION IF EXISTS objects_a7_update_trigger();
        DROP FUNCTION IF EXISTS objects_a8_update_trigger();
        DROP FUNCTION IF EXISTS objects_a10_update_trigger();
        DROP FUNCTION IF EXISTS objects_a12_update_trigger();
        DROP FUNCTION IF EXISTS objects_a12_update_trigger();
        DROP FUNCTION IF EXISTS objects_a14_update_trigger();
        DROP FUNCTION IF EXISTS objects_a16_update_trigger();

        DROP FUNCTION IF EXISTS objects_l_insert_trigger();
        DROP FUNCTION IF EXISTS objects_l9_update_trigger();
        DROP FUNCTION IF EXISTS objects_l10_update_trigger();
        DROP FUNCTION IF EXISTS objects_l12_update_trigger();
        DROP FUNCTION IF EXISTS objects_l12_14_update_trigger();
        DROP FUNCTION IF EXISTS objects_l15_update_trigger();

        DROP FUNCTION IF EXISTS objects_p_insert_trigger();
        DROP FUNCTION IF EXISTS objects_p_update_trigger();
        DROP FUNCTION IF EXISTS objects_p16_update_trigger();',
        schemaname, branch_id::text);
END;
$$ LANGUAGE plpgsql;
