CREATE OR REPLACE FUNCTION vrevisions.drop_views(
    a_schemaname text)
  RETURNS SETOF text AS
$$
DECLARE
    r RECORD;
BEGIN
    FOR r IN
      SELECT viewname, schemaname FROM pg_views
       WHERE schemaname = a_schemaname
       ORDER BY 1
      LOOP
        EXECUTE 'DROP VIEW IF EXISTS '||r.schemaname||'.'||r.viewname||' CASCADE';
        RETURN NEXT r.schemaname||'.'||r.viewname;
    END LOOP;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION vrevisions_stable.prepare_schema(
    schemaname text,
    branch_id bigint)
    RETURNS void AS
$$
BEGIN
    PERFORM vrevisions.drop_views(schemaname);
    EXECUTE format('
        SET search_path=%I,public;

        DROP TABLE IF EXISTS objects_r CASCADE;
        DROP TABLE IF EXISTS objects CASCADE;

        CREATE VIEW objects_g AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_g
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_g
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s''
            UNION ALL
            SELECT id, commit_id, NULL, 0, 0, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_c
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_c AS
            SELECT id, commit_id, NULL::geometry AS the_geom, domain_attrs, service_attrs
                FROM vrevisions_stable.objects_c
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_p AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, part
                FROM vrevisions_stable.objects_p
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_l AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, length, part
                FROM vrevisions_stable.objects_l
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_a AS
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, area, the_center, part
                FROM vrevisions_stable.objects_a
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_r AS
            SELECT id, commit_id, domain_attrs, master_id, slave_id
                FROM vrevisions_stable.objects_r
                JOIN vrevisions_stable.branch_mask USING (branch_mask_id)
                WHERE branches ? ''%2$s'';

        CREATE VIEW objects_a_view AS
            WITH bm AS (
                SELECT branch_mask_id
                FROM vrevisions_stable.branch_mask
                WHERE branches ? ''%2$s'')
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, area, the_center, part
                FROM vrevisions_stable.objects_a
                WHERE branch_mask_id IN (SELECT branch_mask_id FROM bm);

        CREATE VIEW objects_l_view AS
            WITH bm AS (
                SELECT branch_mask_id
                FROM vrevisions_stable.branch_mask
                WHERE branches ? ''%2$s'')
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, length, part
                FROM vrevisions_stable.objects_l
                WHERE branch_mask_id IN (SELECT branch_mask_id FROM bm);

        CREATE VIEW objects_p_view AS
            WITH bm AS (
                SELECT branch_mask_id
                FROM vrevisions_stable.branch_mask
                WHERE branches ? ''%2$s'')
            SELECT id, commit_id, the_geom, zmin, zmax, domain_attrs, service_attrs, part
                FROM vrevisions_stable.objects_p
                WHERE branch_mask_id IN (SELECT branch_mask_id FROM bm);

        CREATE VIEW complex_objects_indirect_highlight_view AS
            WITH bm AS (
                SELECT branch_mask_id
                FROM vrevisions_stable.branch_mask
                WHERE branches ? ''%2$s'')
            SELECT r.master_id,
                l.id,
                l.the_geom,
                l.zmin,
                l.zmax,
                r.domain_attrs,
                r.slave_id,
                l.part
            FROM vrevisions_stable.objects_r r,
                 vrevisions_stable.objects_r r_next,
                 vrevisions_stable.objects_l l
            WHERE r.slave_id = r_next.master_id AND r_next.slave_id = l.id
                AND r.branch_mask_id IN (SELECT branch_mask_id FROM bm)
                AND r_next.branch_mask_id IN (SELECT branch_mask_id FROM bm)
                AND l.branch_mask_id IN (SELECT branch_mask_id FROM bm);

        CREATE VIEW complex_objects_l_highlight_view AS
            WITH bm AS (
                SELECT branch_mask_id
                FROM vrevisions_stable.branch_mask
                WHERE branches ? ''%2$s'')
            SELECT r.master_id,
                l.id,
                l.the_geom,
                l.zmin,
                l.zmax,
                l.part
                FROM vrevisions_stable.objects_r r
                JOIN vrevisions_stable.objects_l l ON r.slave_id = l.id
                WHERE r.branch_mask_id IN (SELECT branch_mask_id FROM bm)
                    AND l.branch_mask_id IN (SELECT branch_mask_id FROM bm);

        DROP FUNCTION IF EXISTS objects_a_insert_trigger();
        DROP FUNCTION IF EXISTS objects_a7_update_trigger();
        DROP FUNCTION IF EXISTS objects_a8_update_trigger();
        DROP FUNCTION IF EXISTS objects_a10_update_trigger();
        DROP FUNCTION IF EXISTS objects_a12_update_trigger();
        DROP FUNCTION IF EXISTS objects_a12_update_trigger();
        DROP FUNCTION IF EXISTS objects_a14_update_trigger();
        DROP FUNCTION IF EXISTS objects_a16_update_trigger();

        DROP FUNCTION IF EXISTS objects_l_insert_trigger();
        DROP FUNCTION IF EXISTS objects_l9_update_trigger();
        DROP FUNCTION IF EXISTS objects_l10_update_trigger();
        DROP FUNCTION IF EXISTS objects_l12_update_trigger();
        DROP FUNCTION IF EXISTS objects_l12_14_update_trigger();
        DROP FUNCTION IF EXISTS objects_l15_update_trigger();

        DROP FUNCTION IF EXISTS objects_p_insert_trigger();
        DROP FUNCTION IF EXISTS objects_p_update_trigger();
        DROP FUNCTION IF EXISTS objects_p16_update_trigger();',
        schemaname, branch_id::text);
END;
$$ LANGUAGE plpgsql;


SELECT vrevisions.for_vrevisions('
CREATE OR REPLACE VIEW objects_a_view AS (SELECT * FROM objects_a);
CREATE OR REPLACE VIEW objects_l_view AS (SELECT * FROM objects_l);
CREATE OR REPLACE VIEW objects_p_view AS (SELECT * FROM objects_p);
');


WITH schemas AS (
    SELECT schemaname FROM pg_views
    WHERE schemaname like 'vrevisions_stable_%' AND viewname='objects_c' ORDER BY 1)
SELECT schemaname, vrevisions_stable.prepare_schema(schemaname, (SUBSTR(schemaname, 19))::bigint)
 FROM schemas;
