DROP FUNCTION IF EXISTS public.get_token();

CREATE OR REPLACE FUNCTION public.get_token()
    RETURNS text AS
$BODY$
DECLARE
    tok bigint;
    ts bigint := floor(EXTRACT(EPOCH FROM NOW()));
BEGIN
    INSERT INTO public.tokens DEFAULT VALUES RETURNING id INTO tok;
    IF mod(tok, 10000) = 0 THEN -- 10k period
        DELETE FROM public.tokens WHERE id < (tok - 100000); -- 100k for history
    END IF;
    RETURN ts||':'||tok;
END;
$BODY$
LANGUAGE plpgsql;


DROP FUNCTION IF EXISTS public.check_token(token bigint);
DROP FUNCTION IF EXISTS public.check_token(token bigint, tab int);
DROP FUNCTION IF EXISTS public.check_token(token character varying);

CREATE OR REPLACE FUNCTION public.check_token(token text)
    RETURNS boolean AS
$BODY$
DECLARE
    tok text := split_part(token, ':', 2);
    ts bigint;
BEGIN
    IF (tok='') THEN
        RETURN FALSE;
    END IF;
    ts := (split_part(token, ':', 1))::bigint;
    IF EXTRACT(EPOCH FROM NOW()) > ts + 3600 THEN -- 1 hours
        RETURN TRUE;
    END IF;
    PERFORM 1 FROM public.tokens WHERE id = tok::bigint;
    RETURN FOUND;
END;
$BODY$
LANGUAGE plpgsql;
