ALTER TABLE mds_dataset.export_meta
    ADD COLUMN region text NOT NULL DEFAULT '';

COMMENT ON COLUMN mds_dataset.export_meta.region IS
    'Export dataset region';

ALTER TABLE mds_dataset.export_files
    ADD COLUMN region text NOT NULL DEFAULT '';

COMMENT ON COLUMN mds_dataset.export_files.region IS
    'Export dataset region';

ALTER TABLE mds_dataset.export_files
    DROP CONSTRAINT IF EXISTS export_files_dataset_id_fkey;

ALTER TABLE mds_dataset.export_meta
    DROP CONSTRAINT IF EXISTS export_meta_pkey;

ALTER TABLE mds_dataset.export_meta
    ADD CONSTRAINT export_meta_pkey PRIMARY KEY (id, region);

ALTER TABLE mds_dataset.export_files
    ADD CONSTRAINT export_files_dataset_id_region_fkey
    FOREIGN KEY (dataset_id, region)
    REFERENCES mds_dataset.export_meta (id, region)
    ON DELETE CASCADE;

