CREATE TABLE social.event_extra_data (
    event_id bigint NOT NULL PRIMARY KEY,
    ft_type_id smallint,
    business_rubric_id bigint,

    CONSTRAINT check_event_extra_data CHECK (
        ft_type_id IS NOT NULL OR business_rubric_id IS NOT NULL
    ),
    CONSTRAINT event_extra_data_event_id_fkey FOREIGN KEY (event_id) REFERENCES social.commit_event(event_id)
);

COMMENT ON TABLE social.event_extra_data IS
    'Additional information about events. '
    'This table is for information that is used only for some rare specific scenarious, '
    'so it is separated out of the commit_event table.';

COMMENT ON COLUMN social.event_extra_data.event_id IS
    'Identity of a commit event.';

COMMENT ON COLUMN social.event_extra_data.ft_type_id IS
    'Type of the related geoobject.';

COMMENT ON COLUMN social.event_extra_data.business_rubric_id IS
    'Business rubric of the related geoobject.';
