CREATE TABLE revision_meta.commit_regions
(
    commit_id bigint PRIMARY KEY,
    regions hstore,
    stable_branch_id bigint,
    created_at timestamp with time zone NOT NULL DEFAULT now(),
    published boolean default FALSE
);

CREATE INDEX commit_regions_regions_idx
    ON revision_meta.commit_regions
    USING gist(regions) WITH (buffering=ON);

CREATE INDEX commit_regions_stable_branch_id_idx
    ON revision_meta.commit_regions
    USING btree(stable_branch_id);
