CREATE TABLE social.suspicious_users (
    uid bigint PRIMARY KEY,
    registered_or_unbanned_at timestamp with time zone NOT NULL,
    first_commit_at timestamp with time zone NOT NULL DEFAULT NOW(),
    last_commit_at timestamp with time zone NOT NULL DEFAULT NOW(),
    changes_0_30_sec int NOT NULL DEFAULT 0
);

COMMENT ON TABLE social.suspicious_users IS
    'Additional information about new and unbanned users.';

COMMENT ON COLUMN social.suspicious_users.uid IS
    'User identity.';

COMMENT ON COLUMN social.suspicious_users.registered_or_unbanned_at IS
    'Registration or unban time.';

COMMENT ON COLUMN social.suspicious_users.first_commit_at IS
    'The creation time of the first moderation task after user''s registration or unban (approximately equal to the commit creation time).';

COMMENT ON COLUMN social.suspicious_users.last_commit_at IS
    'The creation time of the last moderation task (approximately equal to the last commit create time)';

COMMENT ON COLUMN social.suspicious_users.changes_0_30_sec IS
    'The number of moderation tasks such that the time interval since the previous task creation is in the interval [0; 30) seconds.';
