-- New table for skills.
CREATE TABLE social.skills (
  uid bigint,
  category_group_id text,
  resolve_resolution social.resolve_resolution_type,
  amount int NOT NULL,

  PRIMARY KEY (uid, category_group_id, resolve_resolution)
);

COMMENT ON COLUMN social.skills.uid IS
'User identity.';

COMMENT ON COLUMN social.skills.category_group_id IS
'Category group the skills calculated for.';

COMMENT ON COLUMN social.skills.resolve_resolution IS
'The resolution, tasks was "resolved" with.';

COMMENT ON COLUMN social.skills.amount IS
'Amount of tasks resolved with `resolve_resolution` and made for category from `category_group_id` group by the user with `uid` identity.';


-- Increase skills calculation speed.
CREATE INDEX commit_event_created_by_idx ON social.commit_event (created_by);
