ALTER TABLE social.task ADD COLUMN is_created_by_novice boolean;
COMMENT ON COLUMN social.task.is_created_by_novice IS
    'Shows whether the task was created by a novice user. For the description '
    'of the novice users see '
    'https://wiki.yandex-team.ru/maps/dev/core/wikimap/Avtomaticheskoe-vychislenie-jekspertizy';

CREATE INDEX IF NOT EXISTS skills_resolve_resolution_idx ON social.skills USING btree (resolve_resolution);
CREATE INDEX IF NOT EXISTS task_is_created_by_novice_idx ON social.task USING btree (is_created_by_novice);

ALTER TABLE social.skills RENAME COLUMN category_group_id TO category_id;
COMMENT ON COLUMN social.skills.category_id IS
'Category the skills calculated for.';
COMMENT ON COLUMN social.skills.amount IS
'Amount of tasks resolved with `resolve_resolution` and made for category `category_id` by the user with `uid` identity.';
