-- Rename description keys
--
UPDATE social.feedback_task SET description = 
    json_build_object(
        'i18nKey', 'feedback-descriptions:route-lost',
        'i18nParams', json_build_object(
                          'routeLostsPerDay', description->'i18nParams'->'countRouteLost',
                          'tracksPerDay', description->'i18nParams'->'countTracks',
                          'routeLostLink', description->'i18nParams'->'routeLostLink'
                      )
    )
WHERE
    type = 'route-lost' AND
    (description->'i18nKey')::text = '"feedback-descriptions:route-lost"' AND
    description->'i18nParams'->'countRouteLost' IS NOT NULL;

-- Convert string to numbers and combine segmentId + edgeId to one entity

-- After lost track
--
UPDATE social.feedback_task SET attrs =
    ((attrs::jsonb - 'afterLostTrackNumSegment' - 'afterLostTrackIndexRoad') ||
    jsonb_build_object(
        'afterLostTrackSegment', jsonb_build_object(
                                     'segmentId', (attrs->>'afterLostTrackNumSegment')::numeric,
                                     'edgeId', (attrs->>'afterLostTrackIndexRoad')::numeric
                                 )
    ))::json
WHERE
    type = 'route-lost' AND
    attrs->'afterLostTrackNumSegment' IS NOT NULL;

-- After lost route
--
UPDATE social.feedback_task SET attrs =
    ((attrs::jsonb - 'afterLostRouteNumSegment' - 'afterLostRouteIndexRoad') ||
    jsonb_build_object(
        'afterLostRouteSegment', jsonb_build_object(
                                    'segmentId', (attrs->>'afterLostRouteNumSegment')::numeric,
                                    'edgeId', (attrs->>'afterLostRouteIndexRoad')::numeric
                                 )
    ))::json
WHERE
    type = 'route-lost' AND
    attrs->'afterLostRouteNumSegment' IS NOT NULL;

-- Before lost
--
UPDATE social.feedback_task SET attrs =
    ((attrs::jsonb - 'beforeLostNumSegment' - 'beforeLostIndexRoad') ||
    jsonb_build_object(
        'beforeLostSegment', jsonb_build_object(
                                'segmentId',(attrs->>'beforeLostNumSegment')::numeric,
                                'edgeId', (attrs->>'beforeLostIndexRoad')::numeric
                             )
    ))::json
WHERE type = 'route-lost' AND attrs->'beforeLostNumSegment' IS NOT NULL;

-- Convert custom attrs to userData attrs
--
UPDATE social.feedback_task SET attrs =
    json_build_object(
        'userData', attrs
    )
WHERE type = 'route-lost';
