ALTER TABLE social.feedback_task DROP CONSTRAINT type_constraint;
ALTER TABLE social.feedback_task DROP CONSTRAINT workflow_constraint;

CREATE TYPE social.feedback_type AS ENUM (
    'road',
    'street-name',
    'road-speed-limit',
    'road-direction',
    'road-surface',
    'route-gap',
    'route-lost',
    'car-route',
    'pedestrian-route',
    'bicycle-route',
    'building',
    'address',
    'entrance',
    'public-transport-stop',
    'parking',
    'maneuver',
    'barrier',
    'road-closure',
    'road-annotation',
    'traffic-light',
    'other',
    'mandatory-direction-traffic-sign',
    'prohibited-turn-sign',
    'one-way-traffic-sign',
    'traffic-lane-sign',
    'traffic-prohibited-sign',
    'traffic-circle-sign',
    'poi'
);

CREATE TYPE social.feedback_workflow AS ENUM (
    'feedback',
    'task'
);

CREATE TYPE social.feedback_age_type AS ENUM (
    'old',
    'new'
);

ALTER TABLE social.feedback_task
    ALTER COLUMN type TYPE social.feedback_type
        USING type::social.feedback_type;

ALTER TABLE social.feedback_task
    ALTER COLUMN workflow TYPE social.feedback_workflow
        USING workflow::social.feedback_workflow;
