CREATE TABLE social.feedback_preset (
    id serial PRIMARY KEY,
    name text NOT NULL UNIQUE,
    types social.feedback_type [],
    workflows social.feedback_workflow [],
    sources json,
    age_types social.feedback_age_type [],
    hidden boolean
);

COMMENT ON COLUMN social.feedback_preset.sources IS
    'Storing sources as json array,'
    'because we have problems with storing array of strings'
    'as text[] type, when we try to extract its values in'
    'maps/contrib/libpqxx client, because there is no array_parser there.'
    'Problems arise when string consists of several words or/and with commas inside'
    'TODO: convert type to text[] when maps/contrib/libpqxx -> contrib/libpqxx'
