CREATE TABLE sprav.tasks
(
    task_id bigserial PRIMARY KEY,
    object_id bigint NOT NULL,
    permalink bigint,
    sprav_task_id text,
    original_task text NOT NULL,
    sprav_status text NOT NULL DEFAULT 'not_submitted',
    created_by bigint NOT NULL,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),
    updated_at timestamp with time zone NOT NULL DEFAULT NOW()
);

CREATE INDEX sprav_tasks_created_by_idx ON sprav.tasks (created_by);
CREATE INDEX sprav_tasks_object_id_idx ON sprav.tasks (object_id);
CREATE INDEX sprav_tasks_sprav_status_idx ON sprav.tasks (sprav_status);
