ALTER TYPE social.feedback_type RENAME TO feedback_type_old;

CREATE TYPE social.feedback_type AS ENUM (
    'road',
    'street-name',
    'road-speed-limit',
    'road-direction',
    'road-surface',
    'route-gap',
    'route-lost',
    'car-route',
    'pedestrian-route',
    'bicycle-route',
    'building',
    'address',
    'address-experiment',
    'entrance',
    'entrance-experiment',
    'public-transport-stop',
    'parking',
    'maneuver',
    'barrier',
    'road-closure',
    'road-annotation',
    'traffic-light',
    'other',
    'mandatory-direction-traffic-sign',
    'prohibited-turn-sign',
    'one-way-traffic-sign',
    'traffic-lane-sign',
    'traffic-prohibited-sign',
    'traffic-circle-sign',
    'poi'
);

ALTER TABLE social.feedback_task
    ALTER COLUMN type TYPE social.feedback_type
        USING type::text::social.feedback_type;

ALTER TABLE social.feedback_preset
    ALTER COLUMN types TYPE social.feedback_type[]
        USING types::text::social.feedback_type[];

DROP TYPE social.feedback_type_old;
