ALTER TABLE revision_meta.preapproved_commits_queue
ADD COLUMN service_task_id bigint;

CREATE INDEX preapproved_commits_queue_service_task_id_idx
ON revision_meta.preapproved_commits_queue (service_task_id);

COMMENT ON TABLE revision_meta.preapproved_commits_queue IS
'Commits that are already approved, but possibly depend from not approved
ones.';

COMMENT ON COLUMN revision_meta.preapproved_commits_queue.commit_id IS
'Identity of a commit to be approved.';

COMMENT ON COLUMN revision_meta.preapproved_commits_queue.added_at IS
'Timestamp when a commit was added to this queue.';

COMMENT ON COLUMN revision_meta.preapproved_commits_queue.service_task_id IS
'Identity of a service task the commit belongs to. All commits belonging to the
same service task must be approved simultaneously.';
