SET search_path = social,public;

-- create new partition
--
CREATE TABLE feedback_task_outgoing_opened_experiment (
    CONSTRAINT task_outgoing_opened_experiment_pkey PRIMARY KEY (id),

    CONSTRAINT check_bucket_outgoing CHECK (bucket = 'outgoing'),
    CONSTRAINT check_type_experiment CHECK (type IN ('address-experiment', 'entrance-experiment')),
    CONSTRAINT check_source_experiment CHECK (source = 'experiment-recommendations'),

    CONSTRAINT check_null_closed_by CHECK (closed_by IS NULL),
    CONSTRAINT check_null_closed_at CHECK (closed_at IS NULL),
    CONSTRAINT check_null_deployed_at CHECK (deployed_at IS NULL)
)
INHERITS (feedback_task);


-- move data from outgoing_opened to outgoing_opened_experiment
--
INSERT INTO feedback_task_outgoing_opened_experiment
    SELECT * FROM feedback_task_outgoing_opened
        WHERE source = 'experiment-recommendations';

DELETE FROM feedback_task_outgoing_opened
    WHERE source = 'experiment-recommendations';


-- add constraints to outgoing_opened table
--
ALTER TABLE feedback_task_outgoing_opened ADD CONSTRAINT not_experiment_type
    CHECK (type NOT IN ('address-experiment', 'entrance-experiment'));

ALTER TABLE feedback_task_outgoing_opened ADD CONSTRAINT not_experiment_source
    CHECK (source != 'experiment-recommendations');


-- create indices for new partition
--
CREATE INDEX feedback_task_outgoing_opened_experiment_acquired_by_idx ON feedback_task_outgoing_opened_experiment (acquired_by);
CREATE INDEX feedback_task_outgoing_opened_experiment_duplicate_head_id_idx ON feedback_task_outgoing_opened_experiment (duplicate_head_id);
CREATE INDEX feedback_task_outgoing_opened_experiment_object_id_idx ON feedback_task_outgoing_opened_experiment (object_id);
CREATE INDEX feedback_task_outgoing_opened_experiment_position_idx ON feedback_task_outgoing_opened_experiment USING gist (position);
CREATE INDEX feedback_task_outgoing_opened_experiment_type_idx ON feedback_task_outgoing_opened_experiment (type);
CREATE INDEX feedback_task_outgoing_opened_experiment_source_idx ON feedback_task_outgoing_opened_experiment (source);
CREATE INDEX feedback_task_outgoing_opened_experiment_workflow_idx ON feedback_task_outgoing_opened_experiment (workflow);
CREATE INDEX feedback_task_outgoing_opened_experiment_hidden_idx ON feedback_task_outgoing_opened_experiment (hidden);

-- update indices for outgoing_opened partition
--
DROP INDEX feedback_task_outgoing_opened_type_source_workflow_idx;
CREATE INDEX IF NOT EXISTS feedback_task_outgoing_opened_type_idx ON feedback_task_outgoing_opened (type);
CREATE INDEX IF NOT EXISTS feedback_task_outgoing_opened_source_idx ON feedback_task_outgoing_opened (source);
CREATE INDEX IF NOT EXISTS feedback_task_outgoing_opened_workflow_idx ON feedback_task_outgoing_opened (workflow);

-- update indices for outgoing_closed partition
--
CREATE INDEX IF NOT EXISTS feedback_task_outgoing_closed_closed_idx ON feedback_task_outgoing_closed (closed_by);


-- update triggers
--
-- 'pending' -> 'outgoing_opened' or 'outgoing_opened_experiment', 'pending' -> 'outgoing_closed'
--
CREATE OR REPLACE FUNCTION feedback_task_pending_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.bucket = 'incoming' OR NEW.bucket = 'deferred') THEN
        RETURN NEW;
    END IF;

    DELETE FROM social.feedback_task_pending WHERE id = OLD.id;

    IF (NEW.closed_by IS NULL) THEN
        IF (NEW.type IN ('address-experiment', 'entrance-experiment')) THEN
            INSERT INTO social.feedback_task_outgoing_opened_experiment VALUES (NEW.*);
        ELSE
            INSERT INTO social.feedback_task_outgoing_opened VALUES (NEW.*);
        END IF;
    ELSE
        INSERT INTO social.feedback_task_outgoing_closed VALUES (NEW.*);
    END IF;

    RETURN NULL;
END;
$$;

-- 'outgoing_opened_experiment' -> 'outgoing_closed'
--
CREATE OR REPLACE FUNCTION feedback_task_outgoing_opened_experiment_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.closed_by IS NULL) THEN
        RETURN NEW;
    END IF;

    DELETE FROM social.feedback_task_outgoing_opened_experiment WHERE id = OLD.id;
    INSERT INTO social.feedback_task_outgoing_closed VALUES (NEW.*);
    RETURN NULL;
END;
$$;

-- 'outgoing_closed' -> 'outgoing_opened' or 'outgoing_opened_experiment'
--
CREATE OR REPLACE FUNCTION feedback_task_outgoing_closed_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.closed_by IS NOT NULL) THEN
        RETURN NEW;
    END IF;

    DELETE FROM social.feedback_task_outgoing_closed WHERE id = OLD.id;

    IF (NEW.type IN ('address-experiment', 'entrance-experiment')) THEN
        INSERT INTO social.feedback_task_outgoing_opened_experiment VALUES (NEW.*);
    ELSE
        INSERT INTO social.feedback_task_outgoing_opened VALUES (NEW.*);
    END IF;

    RETURN NULL;
END;
$$;


-- feedback_task_outgoing_opened_experiment
--
CREATE TRIGGER feedback_task_outgoing_opened_experiment_1_update_trigger BEFORE UPDATE ON feedback_task_outgoing_opened_experiment
    FOR EACH ROW EXECUTE PROCEDURE feedback_task_outgoing_opened_experiment_update_trigger();

CREATE TRIGGER feedback_task_outgoing_opened_experimenta_2_calc_hash_trigger BEFORE INSERT OR UPDATE ON feedback_task_outgoing_opened_experiment
    FOR EACH ROW EXECUTE PROCEDURE feedback_task_calc_hash_trigger();


SET search_path=public;
