CREATE MATERIALIZED VIEW social.feedback_task_distinct_source_type_mv AS
SELECT
    source,
    type,
    hidden,
    workflow,
    closed_by is not null as closed,
    min(created_at) as min_created_at,
    max(created_at) as max_created_at
FROM social.feedback_task
WHERE
    bucket = 'outgoing'
GROUP BY
    source,
    type,
    hidden,
    workflow,
    closed
WITH DATA;

-- In order to refresh this matview concurrently we must create unique index.
-- Refresh call is executed periodically in schedule_feedback_worker

CREATE UNIQUE INDEX feedback_task_distinct_source_type_mv_idx
ON social.feedback_task_distinct_source_type_mv
(source, type, hidden, workflow, closed, min_created_at, max_created_at);
