CREATE TABLE revision_meta.preapproved_commits_relations (
    commit_id bigint NOT NULL,
    relates_to bigint NOT NULL,
    PRIMARY KEY (commit_id, relates_to)
);

CREATE INDEX preapproved_commits_relations_relates_to_idx
ON revision_meta.preapproved_commits_relations (relates_to);

COMMENT ON TABLE revision_meta.preapproved_commits_relations IS
'Relations between comments from the preapproved queue and commits that block
their approving. There are two logical types of relations:
1. dependancy between consequent commits; and
2. big changes made by a service task that are split on several commits.

The information from this table represents an undirected graph.

The first relation type is calculated by `revision::findDraftContributingCommits()`
functions family. Whereas the second type commits might be related to eachother
or just to one commit from the group, that makes no difference as long as there
is a path from one commit to another.';

COMMENT ON COLUMN revision_meta.preapproved_commits_relations.commit_id IS
'A commit identity from the preapproved queue.';

COMMENT ON COLUMN revision_meta.preapproved_commits_relations.relates_to IS
'A commit identity of a related commit.

Note. This commit might be absent in the preapproved queue. Such commits
blocking approval of all related commits, because they are still in the draft
state.';
