
-- Clean feedback where we don't need subtypes anymore
--
UPDATE social.feedback_task SET attrs = (attrs::jsonb - 'subtype')::json
WHERE source IN (
    'landing', 'landing-navi', 'landing-taxi',
    'mrc-privateapp-barrier', 'experiment-mrc-alexnino-barriers', 'st-nmapsfeedback'
);


-- FBAPI: convert subtype to subsource
--
UPDATE social.feedback_task
SET attrs = ((attrs::jsonb - 'subtype') || '{"subsource":"qid__add_object__aid__entrance"}'::jsonb)::json
WHERE source = 'fbapi' AND type = 'entrance' AND (attrs->'subtype')::text = '"add"';


UPDATE social.feedback_task
SET attrs = ((attrs::jsonb - 'subtype') || '{"subsource":"qid__add_object__aid__toponym"}'::jsonb)::json
WHERE source = 'fbapi' AND type = 'address' AND (attrs->'subtype')::text = '"add"';


UPDATE social.feedback_task
SET attrs = ((attrs::jsonb - 'subtype') || '{"subsource":"qid__wrong_entrance__aid__report_location"}'::jsonb)::json
WHERE source = 'fbapi' AND type = 'entrance' AND (attrs->'subtype')::text = '"fixLocation"';


UPDATE social.feedback_task
SET attrs = ((attrs::jsonb - 'subtype') || '{"subsource":"qid__wrong_entrance__aid__not_found"}'::jsonb)::json
WHERE source = 'fbapi' AND type = 'entrance' AND (attrs->'subtype')::text = '"delete"';


UPDATE social.feedback_task
SET attrs = ((attrs::jsonb - 'subtype') || '{"subsource":"qid__wrong_address__aid__report_address"}'::jsonb)::json
WHERE source = 'fbapi' AND type = 'address' AND (attrs->'subtype')::text = '"reportAddress"';


UPDATE social.feedback_task
SET attrs = ((attrs::jsonb - 'subtype') || '{"subsource":"qid__wrong_address__aid__report_location"}'::jsonb)::json
WHERE source = 'fbapi' AND type = 'address' AND (attrs->'subtype')::text = '"reportLocation"';
