CREATE MATERIALIZED VIEW social.feedback_aoi_oldest_opened_task_mv AS
(
WITH
    aoi_feedback_full AS (
        SELECT
            aoi.aoi_id,
            fb.*
        FROM
            social.feedback_aoi_feed_outgoing_opened aoi
                JOIN
            social.feedback_task_outgoing_opened fb
                ON aoi.feedback_task_id = fb.id
    )
SELECT
    *
FROM (
    SELECT
        af_oldest.aoi_id,
        af_oldest.source,
        af_oldest.type,
        af_oldest.workflow,
        af_oldest.min_created_at,
        af.id,
        row_number() OVER(PARTITION BY af_oldest.aoi_id, af_oldest.source, af_oldest.type, af_oldest.workflow) AS row_id
    FROM
        (
            SELECT
                aoi_id,
                source,
                type,
                workflow,
                MIN(created_at) AS min_created_at
            FROM
                aoi_feedback_full
            GROUP BY
                aoi_id,
                source,
                type,
                workflow
        ) AS af_oldest
            JOIN
        aoi_feedback_full AS af
            ON af_oldest.aoi_id = af.aoi_id AND
               af_oldest.source = af.source AND
               af_oldest.type = af.type AND
               af_oldest.workflow = af.workflow AND
               af_oldest.min_created_at = af.created_at
    ) sub
    WHERE
        row_id = 1
)
WITH DATA;

-- In order to refresh this matview concurrently we must create unique index.
-- Refresh call is executed periodically in schedule_feedback_worker

CREATE UNIQUE INDEX feedback_aoi_oldest_opened_task_mv_idx
ON social.feedback_aoi_oldest_opened_task_mv
(aoi_id, source, type, workflow, min_created_at, id);
