-- Creating new table feedback_event which will share
-- 'event_id' serial with commit_event table
--
CREATE TABLE social.feedback_event
(
    event_id bigint NOT NULL DEFAULT nextval('social.event_id_seq'::regclass) PRIMARY KEY,
    created_by bigint NOT NULL,
    created_at timestamp with time zone NOT NULL,
    feedback_task_id bigint NOT NULL,
    action text NOT NULL,
    type social.event_type NOT NULL CHECK (type = 'closed-feedback'::social.event_type)
);

CREATE INDEX feedback_event_created_by_idx ON social.feedback_event (created_by);
CREATE INDEX feedback_event_created_at_idx ON social.feedback_event (created_at);

-- This query must be last in file because it takes exclusive lock
-- on table. But execution is fast due to presence of 'NOT VALID keyword'
--
ALTER TABLE social.commit_event
ADD CONSTRAINT check_type
CHECK (
    type IN (
        'edit'::social.event_type,
        'complaint'::social.event_type,
        'request-for-deletion'::social.event_type
    )
)
NOT VALID;
