CREATE TABLE social.sent_notifications (
    id       bigserial PRIMARY KEY,
    uid      bigint NOT NULL,
    channel  text NOT NULL,
    type     text NOT NULL,
    args     jsonb DEFAULT '{}' NOT NULL,
    sent_at  timestamp with time zone DEFAULT 'now()' NOT NULL,

    CONSTRAINT valid_channel CHECK (channel IN ('email', 'bell', 'messenger')),
    CONSTRAINT valid_type CHECK (type IN ('welcome-to-service', 'your-edits-are-published'))
);

COMMENT ON COLUMN social.sent_notifications.args IS
    'Arguments that were substituted inside message. '
    'For example number of published commits for email "your commits are published"';

CREATE INDEX IF NOT EXISTS social_sent_notifications_uid_idx
    ON social.sent_notifications USING btree (uid);

CREATE INDEX IF NOT EXISTS social_sent_notifications_sent_at_idx
    ON social.sent_notifications USING btree (sent_at);
