CREATE TABLE social.prompt (
    id           bigserial PRIMARY KEY,
    uid          bigint NOT NULL,
    type         text NOT NULL,
    processed_at timestamp with time zone NOT NULL DEFAULT now()

    CONSTRAINT valid_type CHECK (type IN ('news-subscription'))
);

INSERT INTO social.prompt (uid, type)
    SELECT uid, 'news-subscription' AS type
    FROM social.profile
    WHERE news_subscription_prompt_processed = TRUE;


CREATE INDEX IF NOT EXISTS social_prompt_uid_idx
    ON social.prompt USING btree (uid);
