-- Introduce multicolumn gist index
-- to speed queries for commit_events
-- in subscription regions:
-- https://st.yandex-team.ru/NMAPS-10830
--
-- btree_gist postgresql extension is necessary:
-- https://postgrespro.ru/docs/postgrespro/9.5/btree-gist
CREATE EXTENSION IF NOT EXISTS btree_gist;
CREATE INDEX IF NOT EXISTS commit_event_bgeom_event_id_pr_obj_cat_id_edits_idx
    ON social.commit_event
    USING gist (bounds_geom, event_id, primary_object_category_id)
    WITH (buffering='on')
    WHERE type='edit';
