-- Drop unused index: https://st.yandex-team.ru/NMAPS-11185
DROP INDEX IF EXISTS social.commit_event_bounds_geom_idx;

-- Drop unexpectedly used index: https://st.yandex-team.ru/NMAPS-11226
DROP INDEX IF EXISTS social.commit_event_bgeom_event_id_pr_obj_cat_id_edits_idx;

-- Fix multicolumn btree_gist index: https://st.yandex-team.ru/NMAPS-11226
CREATE INDEX IF NOT EXISTS commit_event_notnull_bgeom_event_id_pr_obj_cat_id_edits_idx
    ON social.commit_event
    USING gist (bounds_geom, event_id, primary_object_category_id)
    WITH (buffering='on')
    WHERE type='edit' AND bounds_geom IS NOT NULL;
