ALTER TABLE social.stats
    ADD COLUMN edits_1d_ago_v2  bigint DEFAULT 0,
    ADD COLUMN edits_7d_ago_v2  bigint DEFAULT 0,
    ADD COLUMN edits_30d_ago_v2 bigint DEFAULT 0,
    ADD COLUMN edits_90d_ago_v2 bigint DEFAULT 0
;


CREATE TABLE rating.full_v2 (
    pos bigint PRIMARY KEY,
    uid bigint NOT NULL,
    score double precision NOT NULL);

CREATE UNIQUE INDEX full_uid_unique_idx ON rating.full_v2 (uid);

CREATE TABLE rating.day_v2 (LIKE rating.full_v2 INCLUDING ALL);
CREATE TABLE rating.week_v2 (LIKE rating.full_v2 INCLUDING ALL);
CREATE TABLE rating.month_v2 (LIKE rating.full_v2 INCLUDING ALL);
CREATE TABLE rating.quarter_v2 (LIKE rating.full_v2 INCLUDING ALL);


CREATE TABLE rating.meta_v2 (
    type text PRIMARY KEY,
    version bigint NOT NULL,
    size bigint NOT NULL);

INSERT INTO rating.meta_v2 VALUES
    ('full', 0, 0), ('day', 0, 0), ('week', 0, 0), ('month', 0, 0), ('quarter', 0, 0);
