CREATE TYPE social.quality_control_resolution_type AS ENUM ('incorrect', 'correct');


CREATE TABLE social.quality_control (
    task_id bigint NOT NULL,
    checked_by bigint NOT NULL,
    checked_at timestamp with time zone NOT NULL DEFAULT NOW(),
    resolution social.quality_control_resolution_type NOT NULL,
    comment text,

    CONSTRAINT quality_control_pkey PRIMARY KEY (task_id, checked_by, checked_at)
);
COMMENT ON TABLE social.quality_control IS
    'Base table with quality control information. '
    'No data is expected to be inserted into this table.';


CREATE TABLE social.quality_control_feedback (
    CONSTRAINT quality_control_feedback_pkey PRIMARY KEY (task_id, checked_by, checked_at)
)
INHERITS (social.quality_control);
COMMENT ON TABLE social.quality_control_feedback IS
    'Quality control information for feedback.'
