--aggregate any arrays
create or replace function acl.array_merge(arr1 anyarray, arr2 anyarray)
    returns anyarray language sql immutable
as $$
    select array_agg(distinct elem order by elem)
    from (
        select unnest(arr1) elem
        union
        select unnest(arr2)
    ) s
$$;

create aggregate acl.array_merge_agg(anyarray) (
    sfunc = acl.array_merge,
    stype = anyarray
);

--

ALTER TABLE acl.permission ADD COLUMN leaf_ids bigint[];

CREATE TABLE acl.cluster
(
    cluster_id bigserial PRIMARY KEY,
    group_ids bigint[],
    role_ids bigint[],
    permission_leaf_ids bigint[]
);

CREATE TABLE acl.agent_cluster
(
    agent_id bigint PRIMARY KEY,
    cluster_id bigint
);

CREATE INDEX cluster_permission_leaf_ids_idx ON acl.cluster USING GIN(permission_leaf_ids) WITH (fastupdate=off);
CREATE INDEX agent_cluster_cluster_id_idx ON acl.agent_cluster USING BTREE (cluster_id);
