 -- Drop tables and types introduced in 447 migration
DROP TABLE IF EXISTS social.quality_control_feedback;
DROP TABLE IF EXISTS social.quality_control;
DROP TYPE IF EXISTS social.quality_control_resolution;

 -- New assessment schema
CREATE SCHEMA IF NOT EXISTS assessment;

CREATE TYPE assessment.grade_type AS ENUM ('incorrect', 'correct');

CREATE TABLE assessment.unit (
    unit_id bigserial PRIMARY KEY,
    entity_id bigint NOT NULL,
    entity_domain text NOT NULL,
    action_by bigint NOT NULL,
    action_at timestamp with time zone NOT NULL,
    action text NOT NULL
);

CREATE UNIQUE INDEX unit_insert_idx
    ON assessment.unit
    USING btree (entity_id, entity_domain, action_by, action_at, action);

CREATE TABLE assessment.grade (
    grade_id bigserial PRIMARY KEY,
    unit_id bigint NOT NULL,
    graded_by bigint NOT NULL,
    graded_at timestamp with time zone NOT NULL DEFAULT NOW(),
    value assessment.grade_type NOT NULL,
    comment text
);

CREATE UNIQUE INDEX grade_insert_idx
    ON assessment.grade
    USING btree (unit_id, graded_by, graded_at)
