CREATE TABLE assessment.sample (
    sample_id bigserial PRIMARY KEY,
    entity_domain text NOT NULL,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),
    name text NOT NULL
);

CREATE TABLE assessment.sample_unit (
    sample_id bigint NOT NULL,
    unit_id bigint NOT NULL,

    CONSTRAINT sample_unit_pkey PRIMARY KEY (sample_id, unit_id)
);

COMMENT ON TABLE assessment.unit IS
    'Entity & action (e.g. feedback task and "accept" operation from its history) to be graded';

COMMENT ON TABLE assessment.sample IS
    'Group of units for assessment';
