ALTER TABLE assessment.sample_unit RENAME TO sample_task;
ALTER INDEX assessment.sample_unit_pkey RENAME TO sample_task_pkey;

ALTER TABLE assessment.sample_task
    ADD COLUMN grade_id bigint,
    ADD COLUMN acquired_by bigint,
    ADD COLUMN acquired_at timestamp with time zone
;

COMMENT ON TABLE assessment.sample_task IS
    'Tasks of which each sample consists';

CREATE TABLE IF NOT EXISTS assessment.unit_skip (
    unit_id bigint NOT NULL,
    skipped_by bigint NOT NULL,
    skipped_at timestamp with time zone NOT NULL DEFAULT NOW(),

    CONSTRAINT unit_skip_pkey PRIMARY KEY (unit_id, skipped_by)
);

CREATE INDEX IF NOT EXISTS unit_skip_skipped_at_idx
    ON assessment.unit_skip USING btree (skipped_at);

COMMENT ON TABLE assessment.unit_skip IS
    'Units not to be acquired by uid';
