CREATE TABLE IF NOT EXISTS acl.role_can_assign_role (
    role_id bigint NOT NULL,
    can_assign_role_id bigint NOT NULL,
    PRIMARY KEY (role_id, can_assign_role_id),
    CONSTRAINT role_can_assign_role_role_foreign_key FOREIGN KEY (role_id) REFERENCES acl.role (id)
    ON UPDATE NO ACTION ON DELETE CASCADE,
    CONSTRAINT role_can_assign_role_can_assign_role_foreign_key FOREIGN KEY (can_assign_role_id) REFERENCES acl.role (id)
    ON UPDATE NO ACTION ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS acl.role_can_assign_group (
    role_id bigint NOT NULL,
    can_assign_group_id bigint NOT NULL,
    PRIMARY KEY (role_id, can_assign_group_id),
    CONSTRAINT role_can_assign_role_role_foreign_key FOREIGN KEY (role_id) REFERENCES acl.role (id)
    ON UPDATE NO ACTION ON DELETE CASCADE,
    CONSTRAINT role_can_assign_role_can_assign_group_foreign_key FOREIGN KEY (can_assign_group_id) REFERENCES acl."group" (id)
    ON UPDATE NO ACTION ON DELETE CASCADE
);

SELECT acl.add_journaling('role_can_assign_role');
SELECT acl.add_journaling('role_can_assign_group');
