SET search_path=validation,public;

CREATE TABLE IF NOT EXISTS exclusion_view (
    attributes_id integer NOT NULL,
    content_id bigint NOT NULL,
    viewed_by bigint NOT NULL,

    PRIMARY KEY (attributes_id, content_id, viewed_by),
    CONSTRAINT valid_user CHECK (viewed_by > 0),

    CONSTRAINT exclusion_attributes_id_fkey FOREIGN KEY (attributes_id) REFERENCES message_attributes (attributes_id)
      ON DELETE CASCADE,
    CONSTRAINT exclusion_content_id_fkey FOREIGN KEY (content_id) REFERENCES message_content (content_id)
      ON DELETE CASCADE,
    CONSTRAINT exclusion_id_fkey FOREIGN KEY (attributes_id, content_id) REFERENCES exclusion (attributes_id, content_id)
      ON DELETE CASCADE
);
