CREATE SCHEMA IF NOT EXISTS gdpr;

CREATE TABLE IF NOT EXISTS gdpr.takeout (
    takeout_id bigserial PRIMARY KEY,
    uid bigint NOT NULL,
    request_id text NOT NULL,
    requested_at timestamp with time zone NOT NULL DEFAULT NOW(),
    completed_at timestamp with time zone
);

CREATE INDEX IF NOT EXISTS takeout_uid_idx
    ON gdpr.takeout USING btree (uid);

CREATE UNIQUE INDEX IF NOT EXISTS takeout_check_once_not_completed_idx
    ON gdpr.takeout USING btree (uid) WHERE completed_at IS NULL;
