CREATE TYPE social.user_activity_action_type AS ENUM (
    'create-commit',
    'create-comment',
    'delete-comment',
    'clear-comments'
);

CREATE TABLE IF NOT EXISTS social.user_activity (
    uid bigint NOT NULL,
    ip_addr inet NOT NULL,
    action social.user_activity_action_type,
    action_at timestamp with time zone NOT NULL DEFAULT NOW(),
    entity_id bigint
);

CREATE INDEX IF NOT EXISTS user_activity_uid_idx
    ON social.user_activity USING btree (uid);

CREATE INDEX IF NOT EXISTS user_activity_action_at_idx
    ON social.user_activity USING btree (action_at);
