CREATE TYPE social.feedback_operation AS ENUM (
    'create',
    'defer',
    'reveal',
    'open',
    'need-info',
    'acquire',
    'release',
    'accept',
    'reject',
    'deploy',
    'comment',
    'hide',
    'show',
    'change-type',
    'mark-viewed',
    'processing-level-up',
    'processing-level-down'
);

CREATE TABLE social.feedback_history (
    feedback_history_id bigserial PRIMARY KEY,
    feedback_task_id bigint NOT NULL,
    modified_at timestamp with time zone NOT NULL DEFAULT NOW(),
    modified_by bigint NOT NULL,

    operation social.feedback_operation NOT NULL,
    params jsonb,
    comment_id bigint
);

CREATE INDEX IF NOT EXISTS feedback_history_feedback_task_id_idx
    ON social.feedback_history USING btree (feedback_task_id);

CREATE INDEX IF NOT EXISTS feedback_history_modified_by_idx
    ON social.feedback_history USING btree (modified_by);
