SET search_path=validation,public;

CREATE TABLE IF NOT EXISTS validation.message_view (
    task_id bigint NOT NULL,
    attributes_id integer NOT NULL,
    content_id bigint NOT NULL,
    viewed_by bigint NOT NULL,

    PRIMARY KEY (task_id, attributes_id, content_id, viewed_by),
    CONSTRAINT valid_user CHECK (viewed_by > 0),
    CONSTRAINT message_view_attributes_id_fkey FOREIGN KEY (attributes_id) REFERENCES message_attributes (attributes_id)
      ON DELETE CASCADE,
    CONSTRAINT message_view_content_id_fkey FOREIGN KEY (content_id) REFERENCES message_content (content_id)
      ON DELETE CASCADE
);
