CREATE TABLE IF NOT EXISTS sprav.walkers_export_company (
    record_id bigserial PRIMARY KEY,
    permalink_id bigint NOT NULL,
    actualization_date timestamp with time zone NOT NULL
);

CREATE TABLE IF NOT EXISTS sprav.walkers_export_entrances (
    record_id bigint REFERENCES sprav.walkers_export_company(record_id) NOT NULL,
    entrance_type text,
    position geometry NOT NULL
);
CREATE INDEX ON sprav.walkers_export_entrances USING btree (record_id);

CREATE TABLE IF NOT EXISTS sprav.walkers_export_photos (
    photo_id bigserial PRIMARY KEY,
    record_id bigint REFERENCES sprav.walkers_export_company(record_id) NOT NULL,
    photo_url text
);
CREATE INDEX ON sprav.walkers_export_photos USING btree (record_id);
